@extends('backend.layout.main') @section('content')

<x-success-message key="message" />
<x-error-message key="not_permitted" />

<section>
    <div class="container-fluid">
        <div class="card">
            <div class="card-header mt-2">
                <h3 class="text-center">Cashbook</h3>
            </div>
            {!! Form::open(['route' => 'cashbook.index', 'method' => 'get']) !!}
            <div class="row mb-3 px-3">
                <div class="col-lg-4 col-md-6 col-sm-12 mt-3">
                    <div class="form-group">
                        <label class="d-block mb-2"><strong>Choose Your Date</strong></label>
                        <div class="input-group">
                            <input type="text" class="daterangepicker-field form-control" value="{{$starting_date}} To {{$ending_date}}" required />
                            <input type="hidden" name="starting_date" value="{{$starting_date}}" />
                            <input type="hidden" name="ending_date" value="{{$ending_date}}" />
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12 mt-3 @if(\Auth::user()->role_id > 2){{'d-none'}}@endif">
                    <div class="form-group">
                        <label class="d-block mb-2"><strong>Choose Warehouse</strong></label>
                        <select id="warehouse_id" name="warehouse_id" class="selectpicker form-control" data-live-search="true" data-live-search-style="begins" >
                            <option value="0">All Warehouse</option>
                            @foreach($lims_warehouse_list as $warehouse)
                                @if($warehouse->id == $warehouse_id)
                                    <option selected value="{{$warehouse->id}}">{{$warehouse->name}}</option>
                                @else
                                    <option value="{{$warehouse->id}}">{{$warehouse->name}}</option>
                                @endif
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-lg-2 col-md-6 col-sm-12 mt-3">
                    <div class="form-group">
                        <label class="d-block mb-2">&nbsp;</label>
                        <button class="btn btn-primary btn-block" type="submit">Submit</button>
                    </div>
                </div>
            </div>
            {!! Form::close() !!}
        </div>

        <!-- Cash Summary Cards -->
        <div class="row mb-3">
            <div class="col-lg-4 col-md-6 col-sm-12 mb-3">
                <div class="card bg-success text-white">
                    <div class="card-body">
                        <h5>Cash on Hand</h5>
                        <h3>$ {{ number_format($cash_on_hand, 2) }}</h3>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 col-sm-12 mb-3">
                <div class="card bg-info text-white">
                    <div class="card-body">
                        <h5>Total Debit (Inward)</h5>
                        <h3>$ {{ number_format($total_debit, 2) }}</h3>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 col-sm-12 mb-3">
                <div class="card bg-warning text-white">
                    <div class="card-body">
                        <h5>Total Credit (Outward)</h5>
                        <h3>$ {{ number_format($total_credit, 2) }}</h3>
                    </div>
                </div>
            </div>
        </div>

        @if(in_array("expenses-add", $all_permission))
            <button class="btn btn-info mb-3" data-toggle="modal" data-target="#cashbook-modal"><i class="dripicons-plus"></i> Add Cashbook Entry</button>
        @endif
    </div>
    <div class="table-responsive mt-3 px-3">
        <table id="cashbook-table" class="table table-bordered cashbook-list cashbook-template" style="width: 100%">
            <thead>
                <tr class="cashbook-header-row">
                    <th colspan="3" class="text-center template-header-left">Debit/Inward</th>
                    <th rowspan="2" class="template-balance">Balance</th>
                    <th colspan="3" class="text-center template-header-right">Credit/Outward</th>
                    <th rowspan="2" class="not-exported">Action</th>
                </tr>
                <tr class="cashbook-subheader-row">
                    <th class="template-date">Date</th>
                    <th class="template-details">Details</th>
                    <th class="template-amount">Amount</th>
                    <th class="template-date">Date</th>
                    <th class="template-details">Details</th>
                    <th class="template-amount">Amount</th>
                </tr>
            </thead>
            <tfoot class="tfoot active cashbook-footer">
                <tr>
                    <th colspan="2" class="text-right font-weight-bold">Total</th>
                    <th id="total-debit-amount" class="text-right">0.00</th>
                    <th></th>
                    <th colspan="2" class="text-right font-weight-bold">Total</th>
                    <th id="total-credit-amount" class="text-right">0.00</th>
                    <th></th>
                </tr>
            </tfoot>
        </table>
    </div>
</section>

<!-- Add Cashbook Modal -->
<div id="cashbook-modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" class="modal fade text-left">
    <div role="document" class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 id="exampleModalLabel" class="modal-title">Add Cashbook Entry</h5>
                <button type="button" data-dismiss="modal" aria-label="Close" class="close"><span aria-hidden="true"><i class="dripicons-cross"></i></span></button>
            </div>
            <div class="modal-body">
              <p class="italic"><small>The field labels marked with * are required input fields.</small></p>
                {!! Form::open(['route' => 'cashbook.store', 'method' => 'post', 'id' => 'cashbook-form']) !!}
                <div class="row">
                    <div class="col-md-6 form-group">
                        <label>Date *</label>
                        <input type="date" name="date" class="form-control" value="{{date('Y-m-d')}}" required>
                    </div>
                    <div class="col-md-6 form-group">
                        <label>Type *</label>
                        <select name="type" class="form-control" required>
                            <option value="">Select Type</option>
                            <option value="debit">Debit (Inward / Received)</option>
                            <option value="credit">Credit (Outward / Payment)</option>
                        </select>
                    </div>
                    <div class="col-md-12 form-group">
                        <label>Details *</label>
                        <input type="text" name="details" class="form-control" required>
                    </div>
                    <div class="col-md-6 form-group">
                        <label>Amount *</label>
                        <input type="number" name="amount" class="form-control" step="0.01" min="0" required>
                    </div>
                    @if(\Auth::user()->role_id <= 2)
                    <div class="col-md-6 form-group">
                        <label>Warehouse</label>
                        <select name="warehouse_id" class="selectpicker form-control" data-live-search="true" data-live-search-style="begins">
                            <option value="">Select Warehouse</option>
                            @foreach($lims_warehouse_list as $warehouse)
                                <option value="{{$warehouse->id}}">{{$warehouse->name}}</option>
                            @endforeach
                        </select>
                    </div>
                    @endif
                    <div class="col-md-12 form-group">
                        <label>Note</label>
                        <textarea name="note" class="form-control" rows="3"></textarea>
                    </div>
                    <div class="col-md-12 form-group">
                        <button type="submit" class="btn btn-primary" id="submit-btn">
                            <span class="btn-text">Submit</span>
                            <span class="btn-loader d-none">
                                <i class="fa fa-spinner fa-spin"></i> Processing...
                            </span>
                        </button>
                    </div>
                </div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
</div>

<!-- Edit Cashbook Modal -->
<div id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" class="modal fade text-left">
    <div role="document" class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 id="exampleModalLabel" class="modal-title">Update Cashbook Entry</h5>
                <button type="button" data-dismiss="modal" aria-label="Close" class="close"><span aria-hidden="true"><i class="dripicons-cross"></i></span></button>
            </div>
            <div class="modal-body">
              <p class="italic"><small>The field labels marked with * are required input fields.</small></p>
                {!! Form::open(['route' => ['cashbook.update', 1], 'method' => 'put', 'id' => 'cashbook-edit-form']) !!}
                <div class="row">
                    <div class="col-md-6 form-group">
                        <label>Date *</label>
                        <input type="date" name="date" class="form-control" required>
                    </div>
                    <div class="col-md-6 form-group">
                        <label>Type *</label>
                        <select name="type" class="form-control" required>
                            <option value="">Select Type</option>
                            <option value="debit">Debit (Inward / Received)</option>
                            <option value="credit">Credit (Outward / Payment)</option>
                        </select>
                    </div>
                    <div class="col-md-12 form-group">
                        <label>Details *</label>
                        <input type="text" name="details" class="form-control" required>
                    </div>
                    <div class="col-md-6 form-group">
                        <label>Amount *</label>
                        <input type="number" name="amount" class="form-control" step="0.01" min="0" required>
                    </div>
                    @if(\Auth::user()->role_id <= 2)
                    <div class="col-md-6 form-group">
                        <label>Warehouse</label>
                        <select name="warehouse_id" class="selectpicker form-control" data-live-search="true" data-live-search-style="begins">
                            <option value="">Select Warehouse</option>
                            @foreach($lims_warehouse_list as $warehouse)
                                <option value="{{$warehouse->id}}">{{$warehouse->name}}</option>
                            @endforeach
                        </select>
                    </div>
                    @endif
                    <div class="col-md-12 form-group">
                        <label>Note</label>
                        <textarea name="note" class="form-control" rows="3"></textarea>
                    </div>
                    <div class="col-md-12 form-group">
                        <button type="submit" class="btn btn-primary" id="update-btn">
                            <span class="btn-text">Update</span>
                            <span class="btn-loader d-none">
                                <i class="fa fa-spinner fa-spin"></i> Updating...
                            </span>
                        </button>
                    </div>
                </div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
</div>

@endsection

@push('styles')
<style>
    /* Cashbook Template Styling to match Excel design */
    .cashbook-template {
        border: 2px solid #333 !important;
    }
    
    .cashbook-template thead th {
        background-color: #4472C4 !important;
        color: white !important;
        font-weight: bold;
        text-align: center;
        border: 1px solid #2c5aa0 !important;
        padding: 10px;
    }
    
    .cashbook-header-row .template-header-left {
        background-color: #5B9BD5 !important;
    }
    
    .cashbook-header-row .template-header-right {
        background-color: #70AD47 !important;
    }
    
    .cashbook-subheader-row th {
        background-color: #D9E1F2 !important;
        color: #333 !important;
        font-weight: 600;
        border: 1px solid #999 !important;
    }
    
    .cashbook-template .template-balance {
        background-color: #E2EFDA !important;
        color: #333 !important;
        font-weight: bold;
        vertical-align: middle !important;
        text-align: center !important;
    }
    
    .cashbook-template tbody td {
        border: 1px solid #ccc !important;
        padding: 8px;
        vertical-align: middle;
    }
    
    .cashbook-template tbody td.text-right {
        background-color: #f9f9f9;
        font-weight: 500;
    }
    
    .cashbook-template tfoot th {
        background-color: #FFF2CC !important;
        color: #333 !important;
        font-weight: bold;
        border: 1px solid #999 !important;
        padding: 10px;
    }
    
    /* Excel-like grid lines */
    .cashbook-template tbody tr:hover {
        background-color: #f5f5f5;
    }
    
    /* Summary cards styling */
    .card.bg-success {
        background: linear-gradient(135deg, #28a745 0%, #20c997 100%) !important;
    }
    
    .card.bg-info {
        background: linear-gradient(135deg, #17a2b8 0%, #5bc0de 100%) !important;
    }
    
    .card.bg-warning {
        background: linear-gradient(135deg, #ffc107 0%, #ff9800 100%) !important;
    }
    
    /* Print styling */
    @media print {
        .cashbook-template {
            border-collapse: collapse;
            width: 100%;
        }
        
        .cashbook-template thead th,
        .cashbook-template tbody td,
        .cashbook-template tfoot th {
            border: 1px solid #000 !important;
            padding: 5px;
        }
        
        .not-exported {
            display: none !important;
        }
    }
    
    /* Mobile responsive styling */
    @media (max-width: 768px) {
        .cashbook-template {
            font-size: 12px;
        }
        
        .cashbook-template thead th,
        .cashbook-template tbody td,
        .cashbook-template tfoot th {
            padding: 5px !important;
        }
        
        .card h3 {
            font-size: 1.2rem;
        }
        
        .card h5 {
            font-size: 0.9rem;
        }
        
        /* Make table scrollable on mobile */
        .table-responsive {
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
        }
        
        /* Stack summary cards on mobile */
        .row .col-lg-4 {
            margin-bottom: 10px;
        }
    }
    
    @media (max-width: 576px) {
        .cashbook-template {
            font-size: 10px;
        }
        
        .btn {
            font-size: 12px;
            padding: 5px 10px;
        }
        
        .card-body h3 {
            font-size: 1rem;
        }
        
        .card-body h5 {
            font-size: 0.8rem;
        }
    }
    
    /* Button loader styling */
    .btn[disabled] {
        opacity: 0.6;
        cursor: not-allowed;
    }
    
    .btn-loader {
        display: inline-block;
    }
    
    .btn-loader i {
        margin-right: 5px;
    }
</style>
@endpush

@push('scripts')
<script type="text/javascript">
    $("ul#account").siblings('a').attr('aria-expanded','true');
    $("ul#account").addClass("show");
    $("ul#account #cashbook-menu").addClass("active");

    var cashbook_id = [];
    var user_verified = <?php echo json_encode(env('USER_VERIFIED')) ?>;

    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    // Handle Add Form Submit
    $('#cashbook-form').on('submit', function(e) {
        e.preventDefault();
        
        var submitBtn = $('#submit-btn');
        var btnText = submitBtn.find('.btn-text');
        var btnLoader = submitBtn.find('.btn-loader');
        
        // Disable button and show loader
        submitBtn.prop('disabled', true);
        btnText.addClass('d-none');
        btnLoader.removeClass('d-none');
        
        $.ajax({
            type: 'POST',
            url: $(this).attr('action'),
            data: $(this).serialize(),
            success: function(data) {
                $('#cashbook-modal').modal('hide');
                $('#cashbook-form')[0].reset();
                $('#cashbook-table').DataTable().ajax.reload();
                alert(data.message);
                
                // Re-enable button and hide loader
                submitBtn.prop('disabled', false);
                btnText.removeClass('d-none');
                btnLoader.addClass('d-none');
            },
            error: function(data) {
                alert('Error adding cashbook entry!');
                
                // Re-enable button and hide loader on error
                submitBtn.prop('disabled', false);
                btnText.removeClass('d-none');
                btnLoader.addClass('d-none');
            }
        });
    });

    // Handle Edit Form Submit
    $('#cashbook-edit-form').on('submit', function(e) {
        e.preventDefault();
        
        var updateBtn = $('#update-btn');
        var btnText = updateBtn.find('.btn-text');
        var btnLoader = updateBtn.find('.btn-loader');
        
        // Disable button and show loader
        updateBtn.prop('disabled', true);
        btnText.addClass('d-none');
        btnLoader.removeClass('d-none');
        
        $.ajax({
            type: 'PUT',
            url: $(this).attr('action'),
            data: $(this).serialize(),
            success: function(data) {
                $('#editModal').modal('hide');
                $('#cashbook-table').DataTable().ajax.reload();
                alert(data.message);
                
                // Re-enable button and hide loader
                updateBtn.prop('disabled', false);
                btnText.removeClass('d-none');
                btnLoader.addClass('d-none');
            },
            error: function(data) {
                alert('Error updating cashbook entry!');
                
                // Re-enable button and hide loader on error
                updateBtn.prop('disabled', false);
                btnText.removeClass('d-none');
                btnLoader.addClass('d-none');
            }
        });
    });

    function confirmDelete() {
        if (confirm("Are you sure want to delete?")) {
            return true;
        }
        return false;
    }

    var starting_date = $('input[name="starting_date"]').val();
    var ending_date = $('input[name="ending_date"]').val();
    var warehouse_id = $('#warehouse_id').val();

    $('#cashbook-table').DataTable( {
        "processing": true,
        "serverSide": true,
        "ajax":{
            url: "{{ route('cashbook.data') }}",
            data:{
                starting_date: starting_date,
                ending_date: ending_date,
                warehouse_id: warehouse_id
            },
            dataType: "json",
            type:"post",
            error: function(xhr, error, thrown) {
                console.log('DataTables Ajax Error:');
                console.log('Response:', xhr.responseText);
                console.log('Status:', xhr.status);
                console.log('Error:', error);
                alert('Error loading cashbook data. Please check console for details.');
            }
        },
        "createdRow": function( row, data, dataIndex ) {
            $(row).attr('data-cashbook_id', data['id']);
        },
        // Map data so that each row shows either debit (left) or credit (right) side
        "columns": [
            { // Debit date
                "data": null,
                "render": function (data, type, row) {
                    return row.type === 'debit' ? row.date : '';
                }
            },
            { // Debit details
                "data": null,
                "render": function (data, type, row) {
                    return row.type === 'debit' ? row.details : '';
                }
            },
            { // Debit amount
                "data": null,
                "render": function (data, type, row) {
                    if (row.type === 'debit') {
                        // For export/sort use numeric value, for display use formatted
                        return type === 'display' ? row.amount_formatted : parseFloat(row.amount);
                    }
                    return type === 'display' ? '' : 0;
                }
            },
            { // Balance (always show in center)
                "data": null,
                "render": function (data, type, row) {
                    return type === 'display' ? row.balance_formatted : parseFloat(row.balance);
                },
                "className": "text-right font-weight-bold"
            },
            { // Credit date
                "data": null,
                "render": function (data, type, row) {
                    return row.type === 'credit' ? row.date : '';
                }
            },
            { // Credit details
                "data": null,
                "render": function (data, type, row) {
                    return row.type === 'credit' ? row.details : '';
                }
            },
            { // Credit amount
                "data": null,
                "render": function (data, type, row) {
                    if (row.type === 'credit') {
                        // For export/sort use numeric value, for display use formatted
                        return type === 'display' ? row.amount_formatted : parseFloat(row.amount);
                    }
                    return type === 'display' ? '' : 0;
                }
            },
            {"data": "options", "className": "text-center"}
        ],
        'language': {
            'lengthMenu': '_MENU_ records per page',
            "info": '<small>Showing _START_ - _END_ (_TOTAL_)</small>',
            "search": 'Search',
            'paginate': {
                'previous': '<i class="dripicons-chevron-left"></i>',
                'next': '<i class="dripicons-chevron-right"></i>'
            }
        },
    order:[['0', 'asc']],
        'columnDefs': [
            {
                "orderable": false,
                'targets': [7]
            },
            {
                "responsivePriority": 1,
                'targets': [0, 4, 7] // Prioritize date, balance, and actions on mobile
            }
        ],
        'select': false,
        'lengthMenu': [[10, 25, 50, -1], [10, 25, 50, "All"]],
        'responsive': true,
        dom: '<"row"<"col-sm-12 col-md-6"l><"col-sm-12 col-md-6"f>><"row"<"col-sm-12"B>><"row"<"col-sm-12"tr>><"row"<"col-sm-12 col-md-5"i><"col-sm-12 col-md-7"p>>',
        rowId: 'ObjectID',
        buttons: [
            {
                extend: 'pdf',
                text: '<i title="export to pdf" class="fa fa-file-pdf-o"></i>',
                exportOptions: {
                    columns: ':visible:Not(.not-exported)',
                    rows: ':visible'
                },
                action: function(e, dt, button, config) {
                    datatable_sum(dt, true);
                    $.fn.dataTable.ext.buttons.pdfHtml5.action.call(this, e, dt, button, config);
                    datatable_sum(dt, false);
                },
                footer:true
            },
            {
                extend: 'excel',
                text: '<i title="export to excel" class="dripicons-document-new"></i>',
                exportOptions: {
                    columns: ':visible:Not(.not-exported)',
                    rows: ':visible'
                },
                action: function(e, dt, button, config) {
                    datatable_sum(dt, true);
                    $.fn.dataTable.ext.buttons.excelHtml5.action.call(this, e, dt, button, config);
                    datatable_sum(dt, false);
                },
                footer:true
            },
            {
                extend: 'csv',
                text: '<i title="export to csv" class="fa fa-file-text-o"></i>',
                exportOptions: {
                    columns: ':visible:Not(.not-exported)',
                    rows: ':visible'
                },
                action: function(e, dt, button, config) {
                    datatable_sum(dt, true);
                    $.fn.dataTable.ext.buttons.csvHtml5.action.call(this, e, dt, button, config);
                    datatable_sum(dt, false);
                },
                footer:true
            },
            {
                extend: 'print',
                text: '<i title="print" class="fa fa-print"></i>',
                exportOptions: {
                    columns: ':visible:Not(.not-exported)',
                    rows: ':visible'
                },
                action: function(e, dt, button, config) {
                    datatable_sum(dt, true);
                    $.fn.dataTable.ext.buttons.print.action.call(this, e, dt, button, config);
                    datatable_sum(dt, false);
                },
                footer:true
            },
            {
                extend: 'colvis',
                text: '<i title="column visibility" class="fa fa-eye"></i>',
                columns: ':gt(0)'
            },
        ],
        drawCallback: function () {
            var api = this.api();
            datatable_sum(api, false);
        }
    });

    function datatable_sum(dt_selector, is_calling_first) {
        var rows = dt_selector.rows({ page: 'current' }).indexes();

        // Debit total is column 2 (index 2)
        var debitTotal = dt_selector.cells(rows, 2, { page: 'current' }).data().reduce(function (a, b) {
            var x = parseFloat(a) || 0;
            var y = parseFloat(b) || 0;
            return x + y;
        }, 0);

        // Credit total is column 6 (index 6)
        var creditTotal = dt_selector.cells(rows, 6, { page: 'current' }).data().reduce(function (a, b) {
            var x = parseFloat(a) || 0;
            var y = parseFloat(b) || 0;
            return x + y;
        }, 0);

        $('#total-debit-amount').html(debitTotal.toFixed(2));
        $('#total-credit-amount').html(creditTotal.toFixed(2));
    }

    if(all_permission.indexOf("expenses-delete") == -1)
        $('.buttons-delete').addClass('d-none');

    // Open Edit Modal
    $(document).on('click', '.open-EditCashbookDialog', function() {
        var id = $(this).data('id');
        var url = "{{ url('cashbook') }}/" + id + "/edit";
        $.get(url, function(data) {
            $('#cashbook-edit-form input[name="date"]').val(data.date.split(' ')[0]);
            $('#cashbook-edit-form select[name="type"]').val(data.type);
            $('#cashbook-edit-form input[name="details"]').val(data.details);
            $('#cashbook-edit-form input[name="amount"]').val(data.amount);
            $('#cashbook-edit-form select[name="warehouse_id"]').val(data.warehouse_id);
            $('#cashbook-edit-form textarea[name="note"]').val(data.note);
            $('#cashbook-edit-form').attr('action', "{{ url('cashbook') }}/" + id);
            $('.selectpicker').selectpicker('refresh');
        });
    });

    // Delete single entry
    $(document).on('click', '.delete-btn', function() {
        var id = $(this).data('id');
        if(confirm('Are you sure you want to delete this entry?')) {
            $.ajax({
                type: 'DELETE',
                url: "{{ url('cashbook') }}/" + id,
                success: function(data) {
                    alert(data.message);
                    $('#cashbook-table').DataTable().ajax.reload();
                },
                error: function(xhr) {
                    console.log('Delete error:', xhr.responseText);
                    alert('Error deleting cashbook entry!');
                }
            });
        }
    });
</script>
@endpush
