<?php

namespace App\Observers;

use App\Models\Payment;
use App\Services\CashbookService;

class PaymentObserver
{
    protected $cashbookService;

    public function __construct(CashbookService $cashbookService)
    {
        $this->cashbookService = $cashbookService;
    }

    /**
     * Handle the Payment "created" event.
     *
     * @param  \App\Models\Payment  $payment
     * @return void
     */
    public function created(Payment $payment)
    {
        $this->cashbookService->createFromPayment($payment);
    }

    /**
     * Handle the Payment "updated" event.
     *
     * @param  \App\Models\Payment  $payment
     * @return void
     */
    public function updated(Payment $payment)
    {
        // Update the corresponding cashbook entry
        $this->cashbookService->updateEntry(
            get_class($payment),
            $payment->id,
            [
                'amount' => $payment->amount,
                'date' => $payment->payment_at ?? $payment->updated_at,
                'note' => $payment->payment_note,
            ]
        );
    }

    /**
     * Handle the Payment "deleted" event.
     *
     * @param  \App\Models\Payment  $payment
     * @return void
     */
    public function deleted(Payment $payment)
    {
        $this->cashbookService->deleteEntry(get_class($payment), $payment->id);
    }
}
