# Key Length

- [Overview](#overview)
- [Configuring Length](#configuring-length)
- [Length Values](#length-values)
- [Random Length](#random-length)

## Overview

The `length` property determines the length of keys that will be generated by a generator. Hence, if the length of the generator is set to `32`, then every key generated by the generator will be 32 characters long. In cases where the `length` property is not explicitly specified for a generator, the length defaults to `16`.

It is also possible for a generator to generate keys of random length. In this case, the `randomLength` property of the generator has a `true` value.
<br/><br/>

## Configuring Length

The length of a generator can be configured in the following ways:

- <h3>Constructor</h3>

    When creating a generator instance either using the `new` keyword or via the `Keygen` facade, you can specify an optional argument which must be one of the valid [length values](#length-values).
    <br/><br/>

- <h3>Method</h3>

    >**`$generator->length([length_value], [bool $propagate])`**

    The `length()` method configures the key length of a generator. Its optional first argument must be one of the valid [length values](#length-values). It also takes an optional `boolean` second argument which determines whether the new length should be used for eligible linked generators. This second argument defaults to `true` if not specified - which means the new length is propagated.
    <br/><br/>

- <h3>Property</h3>

    >**`$generator->length` `=` `length_value`**

    The length of a generator can be configured by directly setting the `length` property to any of the valid [length values](#length-values). Setting the length property directly is equivalent to using the `length()` method, but with a few differences. This takes away the flexibility of preventing mutation propagation.
    <br/><br/>

## Length Values

These are the possible values for configuring the `length` property. If the length value does not match any of these values, then an `InvalidLengthKeygenException` will be thrown.

- **`null`** or **`true`**   
    Resets the length of the generator to the default value of `16` and resets `randomLength` to `false`.
    <br/><br/>

- **`false`**   
    Sets the length to a random value and enables random length - sets `randomLength` to `true`.
    <br/><br/>

- **`numeric`**   
    Sets the length to the parsed integer value of the numeric value and resets `randomLength` to `false`. The numeric value can be a numeric string, integer, floating-point number with only zeroes after the decimal point. The value must be greater than or equal to 1. If the value is less than 1, an `InvalidLengthKeygenException` will be thrown. Valid values include: `20`, `'20'`, `20.0`, `'20.0'`. Invalid values include: `50.6`, `'50.6'`, `0`, `-5`, `'-5.0'`.
    <br/><br/>

## Random Length