<?php

namespace App\Observers;

use App\Models\Returns;
use App\Services\CashbookService;

class ReturnsObserver
{
    protected $cashbookService;

    public function __construct(CashbookService $cashbookService)
    {
        $this->cashbookService = $cashbookService;
    }

    /**
     * Handle the Returns "created" event.
     *
     * @param  \App\Models\Returns  $returns
     * @return void
     */
    public function created(Returns $returns)
    {
        $this->cashbookService->createFromSaleReturn($returns);
    }

    /**
     * Handle the Returns "updated" event.
     *
     * @param  \App\Models\Returns  $returns
     * @return void
     */
    public function updated(Returns $returns)
    {
        $this->cashbookService->updateEntry(
            get_class($returns),
            $returns->id,
            [
                'amount' => $returns->grand_total,
                'date' => $returns->created_at,
            ]
        );
    }

    /**
     * Handle the Returns "deleted" event.
     *
     * @param  \App\Models\Returns  $returns
     * @return void
     */
    public function deleted(Returns $returns)
    {
        $this->cashbookService->deleteEntry(get_class($returns), $returns->id);
    }
}
